<!doctype html>
<html>
<head>
<title>Recorta la imagen y guárdala en la base de datos usando PHP con Ajax</title>
<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/croppie.js"></script>
<script src="js/sweetalert2.all.js"></script>
<link rel="stylesheet" href="css/bootstrap.min.css" />
<link rel="stylesheet" href="css/croppie.css" />
</head>
<body>
<div class="container"> <br />
  <h3 align="left">Recorta la imagen y guárdala en la base de datos usando PHP con Ajax</h3>
  <br />
  <br />
  <div class="panel  panel-primary">
    <div class="panel-heading">Selecciona Image</div>
    <div class="panel-body">
    <div class="row">
    <div class="col-md-6"> 
     <div class="input-group"> <span class="input-group-btn"> <span class="btn btn-primary" onclick="$(this).parent().find('input[type=file]').click();">Browse</span>
        <input  name="insert_image" id="insert_image" accept="image/*" onchange="$(this).parent().parent().find('.form-control').html($(this).val().split(/[\\|/]/).pop());" style="display: none;" type="file">
        </span> <span class="form-control"></span> </div>
        </div>
    </div>
    <hr>
      <br />
      <div id="store_image"></div>
    </div>
  </div>
</div>
</body>
</html>
<div id="insertimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Recortar y guardar imagen</h4>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-8 text-center">
            <div id="image_demo" style="width:350px; margin-top:30px"></div>
          </div>
          <div class="col-md-4" style="padding-top:30px;"><br />
            <br />
            <br/>
            <button class="btn btn-success crop_image">Recortar y guardar</button>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<script>  
$(document).ready(function(){

 $image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:200,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }    
  });

  $('#insert_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      $image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#insertimageModal').modal('show');
  });

  $('.crop_image').click(function(event){
    $image_crop.croppie('result', {
      type: 'canvas',
      size: 'viewport'
    }).then(function(response){
      $.ajax({
        url:'insertar.php',
        type:'POST',
        data:{"image":response},
        success:function(data){
          $('#insertimageModal').modal('hide');
          load_images();
          
		swal({
			position: 'top-end',
		    type: "success",
		    title: 'Imagen guardada en la base de datos',
		    showConfirmButton: false,
		    confirmButtonText: false,
			timer: 1500
	    });

		
		
        }
      })
    });
  });

  load_images();

  function load_images()
  {
    $.ajax({
      url:"buscar.php",
      success:function(data)
      {
        $('#store_image').html(data);
      }
    })
  }

});  
</script>