<?php
require_once 'lib/Request.php';
$requestModel = new Request();
$ip = $requestModel->getIpAddress();
$isValidIpAddress = $requestModel->isValidIpAddress($ip);
?>
<html>
<head>
<title>Obtener la ubicación geográfica por la dirección IP</title>
<link href="assets/css/style.css" type="text/css" rel="stylesheet" />
</head>
<body>
	<div class="txt-heading">Obtener la ubicación geográfica por la dirección IP</div>
			<?php
if ($isValidIpAddress == "") {
    echo "<div class='error'>Dirección IP invalida: $ip</div>";
} else {
    $geoLocationData = $requestModel->getLocation($ip);
    ?>
	<div id="location">
		<div class="geo-location-detail">

			<div class="row">
				<div class="form-label">
					Nombre del país: <?php  echo $geoLocationData['country'];?>
				</div>
			</div>
			<div class="row">
				<div class="form-label">
					Código de país: <?php   echo $geoLocationData['country_code'];?>
				</div>
			</div>
			<div class="row">
				<div class="form-label">
					Dirección IP: <?php  echo $geoLocationData['ip'];?>
				</div>
			</div>
		</div>
	</div>
<?php }?>
</body>
</html>