<?php
include('inc/header.php');
include_once 'config/Database.php';
include_once 'class/Code.php';
$database = new Database();
$db = $database->getConnection();
$code = new Code($db);
if(!empty($_POST['contenido']) && $_POST['contenido']) {	
	$code->message = htmlentities($_POST['contenido']);
	$code->insert();	
}
?>
<title>Editor TinyMCE usando PHP & MySQL: Ejemplo completo</title> 
<script src="tinymce/tinymce.min.js"></script>
<script src="js/tinymce_editor.js"></script>
<script src="https://cdn.jsdelivr.net/gh/google/code-prettify@master/loader/run_prettify.js"></script>
<style>
/* on mobile browsers, I set a width of 100% */
table.mceLayout, textarea.tinyMCE {
    width: 100% !important;
}

/* on large screens, I use a different layout, so 600px are sufficient */
@media only screen and (min-width: 600px) {
    table.mceLayout, textarea.richEditor {
       width: 600px !important;
    }
}
</style>
<?php include('inc/container.php'); ?>
<div class="container">	
	<div class="row">	
	<h3>Editor TinyMCE usando PHP & MySQL: Ejemplo completo</h3>
	<?php
	$result = $code->getPost();
	while ($row = $result->fetch_assoc()) {
		echo "<div><pre class='prettyprint'>".html_entity_decode($row['contenido'])."</pre></div>";
	}
	?>
	<form id="codeForm" method="post">
		<textarea name="contenido" id="content"></textarea><br>			
		<button type="button" id="preview" name="preview" class="btn btn-info saveButton">Vista previa y guardar</button>
	</form>		
	</div>
	
	<div id="previewModal" class="modal fade" role="dialog">
		<div class="modal-dialog">		
			<div class="modal-content">	
				<div class="modal-body">
					<div><pre style="width:100%;height:300px;" id="previewCode" class='prettyprint'></pre></div>
					<button type="button" id="save" name="save" class="btn btn-info saveButton">Guardar</button>
					<button type="button" id="cancel" name="cancel" class="btn btn-info saveButton">Cancelar</button>
				</div>	
			</div>
		</div>
	</div>


</div>
<?php include("inc/footer.php"); ?>