<?php
if (! empty($_FILES["csv-file"]["tmp_name"])) {
    $csvFile = 'animal.csv';
    if (($json = file_get_contents($_FILES["csv-file"]["tmp_name"])) == false) {
        die('No se puede leer el archivo JSON.');
    }
    $jsonString = json_decode($json, true);
    $fp = fopen($csvFile, 'w');
    fputcsv($fp, array_keys($jsonString[0]));
    for ($i = 0; $i < count($jsonString); $i ++) {
        fputcsv($fp, array_values($jsonString[$i]));
    }
    fclose($fp);
    $respuesta = 'JSON a CSV convertido. <a href="' . $csvFile . '" target="_blank">Descargar archivo CSV</a>';
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Convertir JSON a CSV</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container"> <a class="navbar-brand" href="#">BaulPHP</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExample07" aria-controls="navbarsExample07" aria-expanded="false" aria-label="Toggle navigation"> <span class="navbar-toggler-icon"></span> </button>
    <div class="collapse navbar-collapse" id="navbarsExample07">
      <ul class="navbar-nav mr-auto">
        <li class="nav-item active"> <a class="nav-link" href="#">Portada <span class="sr-only">(current)</span></a> </li>
      </ul>
    </div>
  </div>
</nav>
<hr>
<div class="container">
  <div class="card">
    <div class="card-header bg-primary text-white"> Cargar y convertir JSON a CSV </div>
    <div class="card-body">
      <form name="frmUpload" method="post" enctype="multipart/form-data">
        <div class="form-group">
          <div class="col-md-6">
            <div class="input-group">
              <div class="custom-file">
                <input type="file" class="custom-file-input" id="inputGroupFile04" aria-describedby="inputGroupFileAddon04" name="csv-file" accept=".json">
                <label class="custom-file-label" for="inputGroupFile04">Cargar archivo JSON</label>
              </div>
              <div class="input-group-append"> </div>
            </div>
          </div>
        </div>

        <div class="form-group">
          <div class="col-md-6">
            <button class="btn btn-primary" name="convertir">Convertir a CSV</button>
          </div>
        </div>
        <div class="form-group">
          <div class="col-md-6">
            <?php
        if (!empty($respuesta)) 
        { 
        ?>
            <div class="alert alert-success" role="alert"> <?php echo $respuesta; ?> </div>
            <?php 
        } 
        ?>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bs-custom-file-input/dist/bs-custom-file-input.min.js"></script> 
<script>
      bsCustomFileInput.init()

      var btn = document.getElementById('btnResetForm')
      var form = document.querySelector('form')
      btn.addEventListener('click', function() {
        form.reset()
      })
    </script>
</body>
</html>

